<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/workflow.php';
$tracking = trim($_GET['tracking'] ?? '');
$app = $tracking ? db_fetch('SELECT * FROM applications WHERE tracking_no=?',[$tracking]) : null;
if(!$app){ http_response_code(404); echo 'Invalid tracking'; exit; }
$fee = fee_for_type($app['company_type']);
if($_SERVER['REQUEST_METHOD']==='POST'){
  if ($app['status']!=='AUTHORIZED'){
    header('Location: track.php?tracking='.$tracking); exit;
  }
  $method = $_POST['method'] ?? 'MOMO';
  $ref = 'PAY-'.substr($app['tracking_no'],-6).'-'.rand(1000,9999);
  db_execute('INSERT INTO payments(app_id,method,amount,ref,status,created_at) VALUES(?,?,?,?,?,?)',[ $app['id'],$method,$fee,$ref,'PAID',now() ]);
  set_status($app['id'],'PAYMENT_CONFIRMED','Payment confirmed (simulated)');
  header('Location: track.php?tracking='.$tracking); exit;
}
?><!doctype html><html><head><meta charset="utf-8"><title>Simulate Payment</title><meta name="viewport" content="width=device-width,initial-scale=1"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"></head><body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h3 class="mb-3">Simulate Payment</h3>
          <div class="mb-2">Tracking: <code><?php echo e($app['tracking_no']) ?></code></div>
          <div class="mb-2">Company: <?php echo e($app['company_name']) ?></div>
          <div class="mb-3">Amount Due: <span class="fw-semibold">GHS <?php echo e(money($fee)) ?></span></div>
          <?php if($app['status']!=='AUTHORIZED'): ?>
            <div class="alert alert-warning">Payment is only available after authorization.</div>
            <a class="btn btn-outline-secondary" href="track.php?tracking=<?php echo urlencode($tracking) ?>">Back</a>
          <?php else: ?>
          <form method="post">
            <div class="mb-3">
              <label class="form-label">Method</label>
              <select name="method" class="form-select">
                <?php foreach(payment_methods() as $k=>$v): ?>
                  <option value="<?php echo e($k) ?>"><?php echo e($v) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <button class="btn btn-primary">Pay Now</button>
            <a class="btn btn-outline-secondary ms-2" href="track.php?tracking=<?php echo urlencode($tracking) ?>">Cancel</a>
          </form>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
</body></html>
