<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
$tracking = trim($_GET['tracking'] ?? '');
$app = $tracking ? db_fetch('SELECT * FROM applications WHERE tracking_no=?',[$tracking]) : null;
if(!$app){ http_response_code(404); echo 'Invalid tracking'; exit; }
$approved = $app['status']==='APPROVED';
$approvedAt = null;
if ($approved){
  $row = db_fetch("SELECT created_at FROM status_history WHERE app_id=? AND status='APPROVED' ORDER BY id DESC LIMIT 1",[$app['id']]);
  $approvedAt = $row['created_at'] ?? $app['created_at'];
}
$extra = json_decode($app['extra_json'] ?? '{}', true) ?: [];
$company = $extra['company_details'] ?? [];
$activity = trim($company['activity'] ?? '');
if ($activity==='') $activity = 'GENERAL COMMERCIAL ACTIVITIES';
$principal_place = trim($company['registered_office'] ?? '');
$postal_addr = trim($company['postal_address'] ?? '');
$company_tin = trim($company['company_tin'] ?? 'N/A');
$directors = $extra['directors'] ?? [];
$owners = $extra['owners'] ?? [];
$phone = trim($app['phone'] ?? '');
$website = trim($company['website'] ?? '');
// Industrial Classification (Part II)
$isic_industry = trim($company['isic_industry'] ?? '');
$isic_code = trim($company['isic_code'] ?? '');
$isic_desc = trim($company['isic_desc'] ?? '');
$isic_primary = trim($company['isic_primary'] ?? '');
// Auditor (Part VI)
$auditor_name = trim($company['auditor_name'] ?? '');
$auditor_tin = trim($company['auditor_tin'] ?? '');
$auditor_reg_no = trim($company['auditor_reg_no'] ?? '');
$auditor_address = trim($company['auditor_address'] ?? '');
// Capital (Part VII)
$currency = trim($company['capital_currency'] ?? 'GHS');
$authorized_shares = (int)($company['authorized_shares'] ?? 0);
$stated_capital = (float)($company['stated_capital_amount'] ?? 0);
$issue_shares = (int)($company['issued_shares'] ?? 0);
$reg_no = 'CS'.substr(preg_replace('/\D/','', $app['tracking_no']), -9); // simulated
$rgd_office = 'Accra'; // prototype default
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Form 3 - <?php echo e($app['company_name']) ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background:#f8f9fa}
    .doc{background:#fff;border:1px solid #dee2e6;border-radius:8px;box-shadow:0 0.5rem 1rem rgba(0,0,0,.05)}
    .watermark{position:absolute;inset:0;display:flex;align-items:center;justify-content:center;pointer-events:none;opacity:.05;font-size:140px;font-weight:800;letter-spacing:6px;transform: rotate(-22deg)}
    .serif{font-family: Georgia, 'Times New Roman', Times, serif}
    table.form3 td, table.form3 th{padding:.5rem; vertical-align: top}
    .section-title{background:#f1f3f5;font-weight:600}
    @media print{.noprint{display:none}}
  </style>
</head>
<body>
<div class="container py-4">
  <div class="d-flex justify-content-between mb-3 noprint">
    <a class="btn btn-outline-secondary" href="track.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">Back</a>
    <button class="btn btn-primary" onclick="window.print()">Print</button>
  </div>
  <div class="position-relative p-4 doc">
    <div class="watermark">TRUE COPY</div>
    <div class="text-center mb-3">
      <div class="h5 mb-0 serif">Registrar-General's Department — Accra, Ghana</div>
      <div class="h4 mb-0 serif">Form 3</div>
      <div class="small text-muted">THE COMPANIES ACT, 1963 (ACT 179)</div>
    </div>

    <?php if(!$approved): ?>
      <div class="alert alert-warning">This application is not yet approved. Form 3 will be available after approval.</div>
    <?php else: ?>

    <table class="table table-bordered form3">
      <tr class="section-title"><td colspan="4">Part - I &nbsp;&nbsp; Company Details</td></tr>
      <tr>
        <th style="width:25%">Company Registration</th><td style="width:25%"><?php echo e($reg_no) ?></td>
        <th style="width:10%">TIN</th><td style="width:40%"><?php echo e($company_tin ?: 'N/A') ?></td>
      </tr>
      <tr>
        <th>Company Type</th><td><?php echo e(company_types()[$app['company_type']] ?? $app['company_type']) ?></td>
        <th>Company Name</th><td class="text-uppercase fw-semibold"><?php echo e($app['company_name']) ?></td>
      </tr>
      <tr>
        <th>Date Of Incorporation</th><td><?php echo e($approvedAt) ?></td>
        <th>RGD Office</th><td><?php echo e($rgd_office) ?></td>
      </tr>
      <tr>
        <th>Date Of Commencement</th><td><?php echo e($approvedAt) ?></td>
        <th>Principal Activity</th><td><?php echo e($activity) ?></td>
      </tr>
      <tr>
        <th>Nature Of Business</th><td colspan="3"><?php echo e($activity) ?></td>
      </tr>

      <tr class="section-title"><td colspan="4">Part - II &nbsp;&nbsp; Industrial Classification</td></tr>
      <tr>
        <th>Industry</th><td><?php echo e($isic_industry ?: 'N/A') ?></td>
        <th>ISIC Code</th><td><?php echo e($isic_code ?: 'N/A') ?></td>
      </tr>
      <tr>
        <th>ISIC Description</th><td colspan="3"><?php echo e($isic_desc ?: 'N/A') ?></td>
      </tr>
      <tr>
        <th>Primary</th><td><?php echo e($isic_primary ?: 'N/A') ?></td>
        <td colspan="2"></td>
      </tr>

      <tr class="section-title"><td colspan="4">Part - III &nbsp;&nbsp; Address Details</td></tr>
      <tr>
        <th>Principal Place of Business</th><td colspan="3"><?php echo nl2br(e($principal_place ?: 'N/A')) ?></td>
      </tr>
      <tr>
        <th>Registered Address</th><td colspan="3"><?php echo nl2br(e($principal_place ?: 'N/A')) ?></td>
      </tr>
      <tr>
        <th>Postal Address of Business</th><td colspan="3"><?php echo nl2br(e($postal_addr ?: 'N/A')) ?></td>
      </tr>

      <tr class="section-title"><td colspan="4">Part - IV &nbsp;&nbsp; Contact Details</td></tr>
      <tr>
        <th>Phone</th><td><?php echo e($phone ?: 'N/A') ?></td>
        <th>Email</th><td><?php echo e($app['applicant_email'] ?: 'N/A') ?></td>
      </tr>
      <tr>
        <th>URL</th><td colspan="3"><?php echo e($website ?: 'N/A') ?></td>
      </tr>

      <tr class="section-title"><td colspan="4">Part - V &nbsp;&nbsp; Company Officers Details (Directors)</td></tr>
      <tr>
        <td colspan="4">
          <div class="table-responsive">
            <table class="table table-sm table-bordered mb-0">
              <thead class="table-light"><tr>
                <th style="min-width:100px">TIN/ID</th>
                <th style="min-width:220px">Name</th>
                <th>Address</th>
                <th style="min-width:120px">Nationality</th>
                <th style="min-width:120px">Date Of Birth</th>
                <th style="min-width:100px">Designation</th>
              </tr></thead>
              <tbody>
                <?php if($directors): foreach($directors as $d): ?>
                  <tr>
                    <td><?php echo e($d['id'] ?? '') ?></td>
                    <td class="text-uppercase">&nbsp;<?php echo e($d['name'] ?? '') ?></td>
                    <td><?php echo e($principal_place ?: '—') ?></td>
                    <td>—</td>
                    <td>—</td>
                    <td>Director</td>
                  </tr>
                <?php endforeach; else: ?>
                  <tr><td colspan="6" class="text-muted">No directors specified</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </td>
      </tr>

      <tr class="section-title"><td colspan="4">Part - VI &nbsp;&nbsp; Auditor Details</td></tr>
      <tr>
        <th>Auditor Name</th><td><?php echo e($auditor_name ?: 'N/A') ?></td>
        <th>Auditor TIN</th><td><?php echo e($auditor_tin ?: 'N/A') ?></td>
      </tr>
      <tr>
        <th>Auditor Registration No.</th><td><?php echo e($auditor_reg_no ?: 'N/A') ?></td>
        <th>Auditor Address</th><td><?php echo e($auditor_address ?: 'N/A') ?></td>
      </tr>

      <tr class="section-title"><td colspan="4">Part - VII &nbsp;&nbsp; Capital Details</td></tr>
      <tr>
        <th>Currency of Capital</th><td><?php echo e($currency) ?></td>
        <th>Authorized Shares</th><td><?php echo number_format($authorized_shares) ?></td>
      </tr>
      <tr>
        <th>Amount of Stated Capital</th><td><?php echo e(number_format($stated_capital,2)) ?></td>
        <th>Issue Shares</th><td><?php echo number_format($issue_shares) ?></td>
      </tr>

      <tr class="section-title"><td colspan="4">Part - VIII &nbsp;&nbsp; Shares Allotment Details</td></tr>
      <tr>
        <td colspan="4">
          <div class="table-responsive">
            <table class="table table-sm table-bordered mb-0">
              <thead class="table-light"><tr>
                <th style="min-width:100px">TIN/ID</th>
                <th style="min-width:220px">Name</th>
                <th>Address</th>
                <th style="min-width:120px">Shares Allotted</th>
                <th style="min-width:140px">Consideration In Cash (GHS)</th>
              </tr></thead>
              <tbody>
                <?php if($owners): foreach($owners as $o): $sh = (int)($o['percent'] ?? 0) * $issue_shares / 100; ?>
                  <tr>
                    <td><?php echo e($o['id'] ?? '') ?></td>
                    <td class="text-uppercase">&nbsp;<?php echo e($o['name'] ?? '') ?></td>
                    <td><?php echo e($principal_place ?: '—') ?></td>
                    <td><?php echo number_format($sh) ?></td>
                    <td><?php echo number_format($sh,2) ?></td>
                  </tr>
                <?php endforeach; else: ?>
                  <tr><td colspan="5" class="text-muted">No allotments specified</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </td>
      </tr>
    </table>

    <?php endif; ?>
  </div>
</div>
</body>
</html>
