<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
$tracking = trim($_GET['tracking'] ?? '');
$app = $tracking ? db_fetch('SELECT * FROM applications WHERE tracking_no=?',[$tracking]) : null;
if(!$app){ http_response_code(404); echo 'Invalid tracking'; exit; }
$approved = $app['status']==='APPROVED';
$approvedAt = null;
if ($approved){
  $row = db_fetch("SELECT created_at FROM status_history WHERE app_id=? AND status='APPROVED' ORDER BY id DESC LIMIT 1",[$app['id']]);
  $approvedAt = $row['created_at'] ?? $app['created_at'];
}
?><!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Certificate - <?php echo e($app['company_name']) ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background:#f8f9fa}
    .cert{background:#fff;border:1px solid #dee2e6;border-radius:8px;box-shadow:0 0.5rem 1rem rgba(0,0,0,.05)}
    .crest{width:72px;height:72px;background:#222;border-radius:50%;display:inline-block;margin-right:12px}
    .watermark{position:absolute;inset:0;display:flex;align-items:center;justify-content:center;pointer-events:none;opacity:.04;font-size:180px;font-weight:800;letter-spacing:4px}
    @media print{.noprint{display:none}}
  </style>
</head>
<body>
<div class="container py-4">
  <div class="d-flex justify-content-between mb-3 noprint">
    <a class="btn btn-outline-secondary" href="track.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">Back</a>
    <button class="btn btn-primary" onclick="window.print()">Print</button>
  </div>
  <div class="position-relative p-4 cert">
    <div class="watermark">RGD</div>
    <div class="text-center mb-3">
      <span class="crest"></span>
      <div class="d-inline-block text-start align-middle">
        <div class="h6 mb-0">REPUBLIC OF GHANA</div>
        <div class="h5 mb-0">REGISTRAR-GENERAL'S DEPARTMENT</div>
        <div class="small text-muted">Certificate of Incorporation (Simulated)</div>
      </div>
    </div>
    <?php if(!$approved): ?>
      <div class="alert alert-warning">This application is not yet approved. Certificate will be available after approval.</div>
    <?php else: ?>
    <div class="p-3">
      <p>This is to certify that the underlisted entity has been duly registered in accordance with the provisions of the applicable laws of Ghana.</p>
      <div class="row mb-3">
        <div class="col-md-6">
          <div class="text-muted small">Company Name</div>
          <div class="h4"><?php echo e($app['company_name']) ?></div>
        </div>
        <div class="col-md-3">
          <div class="text-muted small">Entity Type</div>
          <div class="h6"><?php echo e(company_types()[$app['company_type']] ?? $app['company_type']) ?></div>
        </div>
        <div class="col-md-3">
          <div class="text-muted small">Certificate No.</div>
          <div class="h6">CERT-<?php echo e(substr($app['tracking_no'],-6)) ?></div>
        </div>
      </div>
      <div class="row mb-3">
        <div class="col-md-6">
          <div class="text-muted small">Tracking Number</div>
          <code class="h6"><?php echo e($app['tracking_no']) ?></code>
        </div>
        <div class="col-md-6">
          <div class="text-muted small">Date of Registration</div>
          <div class="h6"><?php echo e($approvedAt) ?></div>
        </div>
      </div>
      <div class="mt-4 pt-3 border-top">
        <div class="d-flex justify-content-between">
          <div>
            <div class="text-muted small">Registrar</div>
            <div class="fw-semibold">Simulated Signature</div>
          </div>
          <div class="text-end">
            <div class="text-muted small">Verification</div>
            <div class="small">Verify at portal with tracking: <code><?php echo e($app['tracking_no']) ?></code></div>
          </div>
        </div>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
