<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/config.php';
require_once __DIR__ . '/../lib/workflow.php';
$brand = brand();
session_start();
$pay_error = '';
$step_error = '';
$step = isset($_GET['step']) ? max(1, min(5, (int)$_GET['step'])) : 1;
if ($_SERVER['REQUEST_METHOD']==='POST'){
  if ($step===1){
    $type = $_POST['company_type'] ?? '';
    $name = trim($_POST['company_name'] ?? '');
    $act = $_POST['action'] ?? '';
    $_SESSION['apply'] = [ 'company_type'=>$type, 'company_name'=>$name ];
    if ($act==='continue'){
      if ($name===''){
        $step_error = 'Please enter a proposed company name to continue.';
      } else {
        $taken = false;
        if ($name!==''){
          $row = db_fetch('SELECT COUNT(1) c FROM applications WHERE LOWER(company_name)=LOWER(?)',[$name]);
          $taken = ((int)($row['c'] ?? 0))>0;
        }
        if ($taken){
          $step_error = 'The proposed company name is already taken. Please choose another name.';
        } else if ($type){
          header('Location: apply.php?step=2'); exit;
        } else {
          $step_error = 'Please select a company type to continue.';
        }
      }
    }
    $step = 1; // stay on step 1 to allow docs preview after type selection and name check
  }
  if ($step===2){
    $_SESSION['apply'] = array_merge($_SESSION['apply'] ?? [], [
      'applicant_name'=>trim($_POST['applicant_name'] ?? ''),
      'applicant_email'=>trim($_POST['applicant_email'] ?? ''),
      'phone'=>trim($_POST['phone'] ?? ''),
      'address'=>trim($_POST['address'] ?? ''),
      'geo'=>[
        'lat'=>trim($_POST['latitude'] ?? ''),
        'lng'=>trim($_POST['longitude'] ?? ''),
        'name'=>trim($_POST['location_name'] ?? '')
      ]
    ]);
    header('Location: apply.php?step=3'); exit;
  }
  if ($step===3){
    $_SESSION['apply'] = array_merge($_SESSION['apply'] ?? [], [
      'company_details'=>[
        'registered_office'=>trim($_POST['registered_office'] ?? ''),
        'postal_address'=>trim($_POST['postal_address'] ?? ''),
        'company_tin'=>trim($_POST['company_tin'] ?? ''),
        'activity'=>trim($_POST['activity'] ?? ''),
        'website'=>trim($_POST['website'] ?? ''),
        // Industrial Classification (Part II)
        'isic_industry'=>trim($_POST['isic_industry'] ?? ''),
        'isic_code'=>trim($_POST['isic_code'] ?? ''),
        'isic_desc'=>trim($_POST['isic_desc'] ?? ''),
        'isic_primary'=>trim($_POST['isic_primary'] ?? ''),
        // Secretary (Part V)
        'sec_name'=>trim($_POST['sec_name'] ?? ''),
        'sec_address'=>trim($_POST['sec_address'] ?? ''),
        // Auditor (Part VI)
        'auditor_name'=>trim($_POST['auditor_name'] ?? ''),
        'auditor_address'=>trim($_POST['auditor_address'] ?? ''),
        'auditor_tin'=>trim($_POST['auditor_tin'] ?? ''),
        'auditor_reg_no'=>trim($_POST['auditor_reg_no'] ?? ''),
        // Capital (Part VII)
        'capital_currency'=>trim($_POST['capital_currency'] ?? ''),
        'authorized_shares'=>trim($_POST['authorized_shares'] ?? ''),
        'stated_capital_amount'=>trim($_POST['stated_capital_amount'] ?? ''),
        'issued_shares'=>trim($_POST['issued_shares'] ?? ''),
      ]
    ]);
    header('Location: apply.php?step=4'); exit;
  }
  if ($step===4){
    // Parse directors and owners arrays
    $dirs = [];
    $d_names = $_POST['directors_name'] ?? [];
    foreach ($d_names as $i=>$name){
      $name = trim($name); if($name==='') continue;
      $dirs[] = [
        'name'=>$name,
        'id'=>trim($_POST['directors_id'][$i] ?? ''),
        'email'=>trim($_POST['directors_email'][$i] ?? ''),
        'phone'=>trim($_POST['directors_phone'][$i] ?? ''),
        'nat'=>trim($_POST['directors_nat'][$i] ?? ''),
        'dob'=>trim($_POST['directors_dob'][$i] ?? ''),
        'pob'=>trim($_POST['directors_pob'][$i] ?? ''),
        'positions'=>trim($_POST['directors_positions'][$i] ?? '')
      ];
    }
    $owners = [];
    $o_names = $_POST['owners_name'] ?? [];
    foreach ($o_names as $i=>$name){
      $name = trim($name); if($name==='') continue;
      $owners[] = [
        'name'=>$name,
        'id'=>trim($_POST['owners_id'][$i] ?? ''),
        'percent'=>trim($_POST['owners_percent'][$i] ?? ''),
        'nat'=>trim($_POST['owners_nat'][$i] ?? ''),
        'dob'=>trim($_POST['owners_dob'][$i] ?? ''),
        'pob'=>trim($_POST['owners_pob'][$i] ?? '')
      ];
    }
    $_SESSION['apply'] = array_merge($_SESSION['apply'] ?? [], [
      'directors'=>$dirs,
      'owners'=>$owners
    ]);
    if (count($dirs) < 2 || count($owners) < 2){
      $step_error = 'Please provide at least two Directors and at least two Shareholders/Guarantors.';
      // fall through to render step 4 again
    } else {
      header('Location: apply.php?step=5'); exit;
    }
  }
  if ($step===5){
    $data = $_SESSION['apply'] ?? [];
    if (!$data || empty($data['company_type']) || empty($data['company_name']) || empty($data['applicant_name'])){
      header('Location: apply.php'); exit;
    }
    $fee = fee_for_type($data['company_type']);
    $ps = paystack_cfg();
    $ref = trim($_POST['paystack_ref'] ?? '');
    $verified = false; $pay_ref = '';

    if (trim((string)$ps['secret_key']) !== ''){
      if ($ref==='') { $pay_error = 'Payment was not completed. Please complete payment to submit.'; }
      else {
        $url = 'https://api.paystack.co/transaction/verify/'.rawurlencode($ref);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer '.trim((string)$ps['secret_key'])]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $resp = curl_exec($ch); $err = curl_error($ch); curl_close($ch);
        if(!$err){
          $dataResp = json_decode($resp,true);
          $stat = $dataResp['data']['status'] ?? '';
          $amount = ((int)($dataResp['data']['amount'] ?? 0))/100;
          $currency = $dataResp['data']['currency'] ?? '';
          if ($stat==='success' && $currency==='GHS' && $amount >= (float)$fee){ $verified=true; $pay_ref=$ref; }
          else { $pay_error = 'Payment verification failed.'; }
        } else { $pay_error = 'Payment verification error.'; }
      }
    } else {
      $verified = true; $pay_ref = 'SIM-'.time();
    }

    if ($verified) {
      // Enforce required files for Private Limited
      $requiredMissing = [];
      if (($data['company_type'] ?? '') === 'PRIVATE_LIMITED'){
        $labels = doc_labels();
        // Beneficial Ownership Form (single)
        if (empty($_FILES['doc_BO_FORM']['name'])){ $requiredMissing[] = ($labels['BO_FORM'] ?? 'Beneficial Ownership Form'); }
        // Company Constitution/Regulations (single)
        if (empty($_FILES['doc_CONSTITUTION']['name'])){ $requiredMissing[] = ($labels['CONSTITUTION'] ?? 'Company Constitution/Regulations'); }
        // Incorporation Form (single)
        if (empty($_FILES['doc_FORM_OF_INCORP']['name'])){ $requiredMissing[] = ($labels['FORM_OF_INCORP'] ?? 'Incorporation Form'); }
        // Directors IDs (multi) ensure at least one file
        $d = $_FILES['doc_DIRECTORS_IDS'] ?? null;
        $hasDir = false;
        if ($d){
          if (is_array($d['name'])){ foreach($d['name'] as $nm){ if(trim((string)$nm)!==''){ $hasDir=true; break; } } }
          else { $hasDir = trim((string)$d['name'])!==''; }
        }
        if(!$hasDir){ $requiredMissing[] = ($labels['DIRECTORS_IDS'] ?? 'Directors IDs'); }
        // Auditor Consent Declaration (single)
        if (empty($_FILES['doc_AUD_CONSENT_DECL']['name'])){ $requiredMissing[] = ($labels['AUD_CONSENT_DECL'] ?? 'Auditor Consent Declaration'); }
        // Directors Consent (multi) ensure at least one file
        $dc = $_FILES['doc_DIR_CONSENT'] ?? null;
        $hasDirCons = false;
        if ($dc){
          if (is_array($dc['name'])){ foreach($dc['name'] as $nm){ if(trim((string)$nm)!==''){ $hasDirCons=true; break; } } }
          else { $hasDirCons = trim((string)$dc['name'])!==''; }
        }
        if(!$hasDirCons){ $requiredMissing[] = ($labels['DIR_CONSENT'] ?? 'Director Consent'); }
      }
      if ($requiredMissing){
        $pay_error = 'Please upload the required document(s): '.implode(', ', $requiredMissing).'.';
      } else {
      $tracking = generate_tracking_no();
      $docs_req = required_docs_for_type($data['company_type']);
      $doc_texts = [];
      foreach ($docs_req as $dk){
        $v = trim($_POST['doctext_'.$dk] ?? '');
        if ($v !== '') { $doc_texts[$dk] = $v; }
      }
      $extra = [
        'company_details'=>$data['company_details'] ?? [],
        'directors'=>$data['directors'] ?? [],
        'owners'=>$data['owners'] ?? [],
        'geo'=>$data['geo'] ?? null,
        'doc_texts'=>$doc_texts
      ];
      db_execute('INSERT INTO applications(tracking_no,company_type,company_name,applicant_name,applicant_email,phone,address,extra_json,status,created_at) VALUES(?,?,?,?,?,?,?,?,?,?)',[
        $tracking,$data['company_type'],$data['company_name'],$data['applicant_name'],$data['applicant_email'],$data['phone'],$data['address'],json_encode($extra,JSON_UNESCAPED_UNICODE),'SUBMITTED',now()
      ]);
      $app_id = db_last_id();
      $docs = required_docs_for_type($data['company_type']);
      $updir = realpath(__DIR__ . '/../uploads');
      if ($updir===false){ $updir = __DIR__ . '/../uploads'; @mkdir($updir,0777,true); }
      foreach ($docs as $dk){
        $key = 'doc_'.$dk;
        if (!isset($_FILES[$key])) continue;
        $f = $_FILES[$key];
        if (is_array($f['name'])){
          $count = count($f['name']);
          for($ix=0;$ix<$count;$ix++){
            if (empty($f['name'][$ix])) continue;
            $fname = $tracking.'_'.$dk.'_'.time().'_'.$ix.'_'.preg_replace('/[^A-Za-z0-9_.-]/','_',$f['name'][$ix]);
            $dest = $updir . '/' . $fname;
            @move_uploaded_file($f['tmp_name'][$ix],$dest);
            db_execute('INSERT INTO app_docs(app_id,doc_key,file_name,uploaded_at) VALUES(?,?,?,?)',[$app_id,$dk,$fname,now()]);
          }
        } else {
          if (!empty($f['name'])){
            $fname = $tracking.'_'.$dk.'_'.time().'_'.preg_replace('/[^A-Za-z0-9_.-]/','_',$f['name']);
            $dest = $updir . '/' . $fname;
            @move_uploaded_file($f['tmp_name'],$dest);
            db_execute('INSERT INTO app_docs(app_id,doc_key,file_name,uploaded_at) VALUES(?,?,?,?)',[$app_id,$dk,$fname,now()]);
          }
        }
      }
      db_execute('INSERT INTO payments(app_id,method,amount,ref,status,created_at) VALUES(?,?,?,?,?,?)',[$app_id,'CARD',$fee,$pay_ref,'PAID',now()]);
      add_message($app_id,'OUT','Payment received','Payment of GHS '.money($fee).' received via Paystack (Ref '.$pay_ref.').',null);
      add_message($app_id,'OUT','Application submitted','Your application has been submitted successfully. Tracking: '.$tracking.'.',null);
      db_execute('INSERT INTO status_history(app_id,status,note,user_id,created_at) VALUES(?,?,?,?,?)',[$app_id,'SUBMITTED','Application submitted by applicant',null,now()]);
      $_SESSION['apply']=null; unset($_SESSION['apply']);
      header('Location: apply_success.php?tracking='.$tracking); exit;
      }
    }
    // else fall through to render step 5 again with $pay_error
  }
}
$types = company_types();
?><!doctype html><html><head><meta charset="utf-8"><title>Apply - Public Portal</title><meta name="viewport" content="width=device-width,initial-scale=1"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"><style>:root{--brand: <?php echo e($brand['color']) ?>}
  .gh-flag{display:flex;height:4px}
  .gh-flag span{flex:1}
  .gh-flag .red{background:#ce1126}
  .gh-flag .gold{background:#fcd116}
  .gh-flag .green{background:#006b3f}
</style></head><body class="bg-light">
<nav class="navbar navbar-dark" style="background: var(--brand)"><div class="container">
  <a class="navbar-brand d-flex align-items-center" href="index.php">
    <?php if($brand['logo']): ?><img src="<?php echo e(brand_logo_src()) ?>" alt="Logo" style="height:28px" class="me-2"><?php endif; ?>
    <?php echo e($brand['name']) ?> — Public Portal
  </a>
</div></nav>
<div class="gh-flag"><span class="red"></span><span class="gold"></span><span class="green"></span></div>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-8">
      <div class="mb-4">
        <a href="index.php" class="link-secondary">Back</a>
        <h2 class="fw-bold mt-2">New Company Registration</h2>
      </div>
      <?php if($step===1): ?>
      <form method="post">
        <div class="card shadow-sm">
          <div class="card-body">
            <?php if($step_error): ?><div class="alert alert-danger"><?php echo e($step_error) ?></div><?php endif; ?>
            <div class="mb-3">
              <label class="form-label">Company Type</label>
              <select name="company_type" class="form-select" required onchange="this.form.submit()">
                <option value="">Select company type</option>
                <?php foreach($types as $k=>$v): $sel = (($_SESSION['apply']['company_type']??'')===$k)?'selected':''; ?>
                  <option value="<?php echo e($k)?>" <?php echo $sel; ?>><?php echo e($v)?> (GHS <?php echo e(money(fee_for_type($k)))?>)</option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="mb-3">
              <label class="form-label">Proposed Company Name</label>
              <input id="companyName" name="company_name" class="form-control" required value="<?php echo e($_SESSION['apply']['company_name']??'')?>" placeholder="e.g. Sunrise Ventures Ltd">
              <div class="form-text" id="nameStatus"></div>
            </div>
            <?php if(!empty($_SESSION['apply']['company_type'])): $req = required_docs_for_type($_SESSION['apply']['company_type']); ?>
            <div class="alert alert-info"><div class="fw-semibold">Required documents</div>
              <ul class="mb-0">
                <?php foreach($req as $r): $lbl = doc_labels()[$r] ?? $r; $link = doc_link($r); ?>
                  <li>
                    <?php if($link): ?>
                      <a href="<?php echo e($link) ?>" target="_blank"><?php echo e($lbl) ?></a>
                    <?php else: ?>
                      <?php echo e($lbl) ?>
                    <?php endif; ?>
                  </li>
                <?php endforeach; ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>
          <div class="card-footer text-end">
            <button id="continueBtn" class="btn btn-primary" type="submit" name="action" value="continue">Continue</button>
          </div>
        </div>
      </form>
      <script>
      (function(){
        const input = document.getElementById('companyName');
        const status = document.getElementById('nameStatus');
        const btn = document.getElementById('continueBtn');
        if(!input || !status || !btn) return;
        let t=null; let last='';
        async function check(){
          const q = (input.value||'').trim();
          if(!q){ status.textContent=''; btn.disabled=false; return; }
          if(q===last) return; last=q;
          status.textContent='Checking availability...'; btn.disabled=true;
          try{
            const r = await fetch('check_name.php?q='+encodeURIComponent(q));
            const j = await r.json();
            if(j && j.available){ status.textContent='Name is available'; status.style.color='#0a7d20'; btn.disabled=false; }
            else { status.textContent='Name is already taken. Please choose a different name.'; status.style.color='#b01515'; btn.disabled=true; }
          }catch(e){ status.textContent='Unable to check availability right now.'; status.style.color='#6c757d'; btn.disabled=false; }
        }
        input.addEventListener('input', function(){ clearTimeout(t); t=setTimeout(check, 400); });
        input.addEventListener('blur', check);
      })();
      </script>
      <?php endif; ?>

      <?php if($step===2): ?>
      <form method="post">
        <div class="card shadow-sm">
          <div class="card-body">
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">Applicant Name</label>
                <input name="applicant_name" class="form-control" required value="<?php echo e($_SESSION['apply']['applicant_name']??'')?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">Email</label>
                <input type="email" name="applicant_email" class="form-control" value="<?php echo e($_SESSION['apply']['applicant_email']??'')?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">Phone</label>
                <input name="phone" class="form-control" value="<?php echo e($_SESSION['apply']['phone']??'')?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">Address / GPS</label>
                <div class="input-group">
                  <input id="addressInput" name="address" class="form-control" value="<?php echo e($_SESSION['apply']['address']??'')?>" placeholder="Enter address or use location">
                  <button class="btn btn-outline-secondary" type="button" id="useLocationBtn">Use my location</button>
                </div>
                <div class="form-text" id="locationStatus"></div>
                <input type="hidden" name="latitude" id="latitude" value="<?php echo e($_SESSION['apply']['geo']['lat']??'')?>">
                <input type="hidden" name="longitude" id="longitude" value="<?php echo e($_SESSION['apply']['geo']['lng']??'')?>">
                <input type="hidden" name="location_name" id="location_name" value="<?php echo e($_SESSION['apply']['geo']['name']??'')?>">
              </div>
            </div>
          </div>
          <div class="card-footer d-flex justify-content-between">
            <a class="btn btn-outline-secondary" href="apply.php?step=1">Back</a>
            <button class="btn btn-primary" type="submit">Continue</button>
          </div>
        </div>
      </form>
      <script>
      (function(){
        const btn = document.getElementById('useLocationBtn');
        if(!btn) return;
        const addr = document.getElementById('addressInput');
        const latEl = document.getElementById('latitude');
        const lngEl = document.getElementById('longitude');
        const nameEl = document.getElementById('location_name');
        const statusEl = document.getElementById('locationStatus');
        btn.addEventListener('click', function(){
          if(!navigator.geolocation){ statusEl.textContent = 'Geolocation is not supported on this device.'; return; }
          statusEl.textContent = 'Locating...';
          navigator.geolocation.getCurrentPosition(async function(pos){
            const lat = pos.coords.latitude.toFixed(6);
            const lng = pos.coords.longitude.toFixed(6);
            latEl.value = lat; lngEl.value = lng;
            try{
              const resp = await fetch('reverse_geocode.php?lat='+lat+'&lng='+lng);
              const data = await resp.json();
              const name = data.display_name || (lat+','+lng);
              nameEl.value = name;
              addr.value = name + ' ('+lat+','+lng+')';
              statusEl.textContent = 'Location captured.';
            }catch(e){
              addr.value = lat+','+lng;
              statusEl.textContent = 'Coordinates captured.';
            }
          }, function(err){
            statusEl.textContent = 'Unable to get location.';
          }, { enableHighAccuracy: true, timeout: 15000, maximumAge: 0 });
        });
      })();
      </script>
      <?php endif; ?>

      <?php if($step===3): ?>
      <form method="post">
        <div class="card shadow-sm">
          <div class="card-body">
            <div class="row g-3">
              <div class="col-md-12">
                <label class="form-label">Registered Office Address</label>
                <textarea name="registered_office" class="form-control" rows="2" required><?php echo e($_SESSION['apply']['company_details']['registered_office'] ?? '')?></textarea>
              </div>
              <div class="col-md-12">
                <label class="form-label">Postal Address</label>
                <input name="postal_address" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['postal_address'] ?? '')?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">Company TIN</label>
                <input name="company_tin" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['company_tin'] ?? '')?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">Website</label>
                <input name="website" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['website'] ?? '')?>">
              </div>
              <div class="col-md-12">
                <label class="form-label">Nature of Business / Principal Activity</label>
                <textarea name="activity" class="form-control" rows="2"><?php echo e($_SESSION['apply']['company_details']['activity'] ?? '')?></textarea>
              </div>
              <?php $ct = $_SESSION['apply']['company_type'] ?? ''; if ($ct==='PRIVATE_LIMITED'): ?>
              <div class="col-md-12"><hr class="my-2"><div class="fw-semibold">Part II — Industrial Classification</div></div>
              <div class="col-md-6">
                <label class="form-label">Industry</label>
                <select id="isicIndustry" name="isic_industry" class="form-select">
                  <?php $indSel = $_SESSION['apply']['company_details']['isic_industry'] ?? ''; ?>
                  <option value="" <?php echo $indSel===''?'selected':''; ?>>Select an industry</option>
                  <option value="Technology" <?php echo $indSel==='Technology'?'selected':''; ?>>Technology</option>
                  <option value="Banking" <?php echo $indSel==='Banking'?'selected':''; ?>>Banking</option>
                  <option value="Insurance" <?php echo $indSel==='Insurance'?'selected':''; ?>>Insurance</option>
                  <option value="Manufacturing" <?php echo $indSel==='Manufacturing'?'selected':''; ?>>Manufacturing</option>
                  <option value="Agriculture" <?php echo $indSel==='Agriculture'?'selected':''; ?>>Agriculture</option>
                  <option value="Construction" <?php echo $indSel==='Construction'?'selected':''; ?>>Construction</option>
                  <option value="Education" <?php echo $indSel==='Education'?'selected':''; ?>>Education</option>
                  <option value="Healthcare" <?php echo $indSel==='Healthcare'?'selected':''; ?>>Healthcare</option>
                  <option value="Transportation" <?php echo $indSel==='Transportation'?'selected':''; ?>>Transportation</option>
                  <option value="Real Estate" <?php echo $indSel==='Real Estate'?'selected':''; ?>>Real Estate</option>
                  <option value="Energy" <?php echo $indSel==='Energy'?'selected':''; ?>>Energy / Utilities</option>
                  <option value="Hospitality" <?php echo $indSel==='Hospitality'?'selected':''; ?>>Hospitality</option>
                  <option value="Retail" <?php echo $indSel==='Retail'?'selected':''; ?>>Retail Trade</option>
                  <option value="Mining" <?php echo $indSel==='Mining'?'selected':''; ?>>Mining</option>
                  <option value="Telecommunications" <?php echo $indSel==='Telecommunications'?'selected':''; ?>>Telecommunications</option>
                </select>
              </div>
              <div class="col-md-4">
                <label class="form-label">ISIC Code</label>
                <input name="isic_code" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['isic_code'] ?? '')?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">ISIC Description</label>
                <input name="isic_desc" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['isic_desc'] ?? '')?>">
              </div>
              <div class="col-md-2">
                <label class="form-label">Primary</label>
                <select name="isic_primary" class="form-select">
                  <?php $prim = $_SESSION['apply']['company_details']['isic_primary'] ?? ''; ?>
                  <option value="" <?php echo $prim===''?'selected':''; ?>>Select</option>
                  <option value="Yes" <?php echo $prim==='Yes'?'selected':''; ?>>Yes</option>
                  <option value="No" <?php echo $prim==='No'?'selected':''; ?>>No</option>
                </select>
              </div>
              <div class="col-md-12"><hr class="my-2"><div class="fw-semibold">Part V — Company Secretary & Auditor</div></div>
              <div class="col-md-6">
                <label class="form-label">Company Secretary Name</label>
                <input name="sec_name" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['sec_name'] ?? '')?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">Company Secretary Address</label>
                <input name="sec_address" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['sec_address'] ?? '')?>">
              </div>
              <div class="col-md-4">
                <label class="form-label">Auditor Name</label>
                <input name="auditor_name" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['auditor_name'] ?? '')?>">
              </div>
              <div class="col-md-4">
                <label class="form-label">Auditor TIN</label>
                <input name="auditor_tin" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['auditor_tin'] ?? '')?>">
              </div>
              <div class="col-md-4">
                <label class="form-label">Auditor Registration No.</label>
                <input name="auditor_reg_no" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['auditor_reg_no'] ?? '')?>">
              </div>
              <div class="col-md-12">
                <label class="form-label">Auditor Address</label>
                <input name="auditor_address" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['auditor_address'] ?? '')?>">
              </div>
              <div class="col-md-12"><hr class="my-2"><div class="fw-semibold">Part VII — Capital Details</div></div>
              <div class="col-md-3">
                <label class="form-label">Currency of Capital</label>
                <input name="capital_currency" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['capital_currency'] ?? 'GHS')?>">
              </div>
              <div class="col-md-3">
                <label class="form-label">Authorized Shares</label>
                <input name="authorized_shares" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['authorized_shares'] ?? '')?>">
              </div>
              <div class="col-md-3">
                <label class="form-label">Amount of Stated Capital</label>
                <input name="stated_capital_amount" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['stated_capital_amount'] ?? '')?>">
              </div>
              <div class="col-md-3">
                <label class="form-label">Issued Shares</label>
                <input name="issued_shares" class="form-control" value="<?php echo e($_SESSION['apply']['company_details']['issued_shares'] ?? '')?>">
              </div>
              <?php endif; ?>
            </div>
          </div>
          <div class="card-footer d-flex justify-content-between">
            <a class="btn btn-outline-secondary" href="apply.php?step=2">Back</a>
            <button class="btn btn-primary" type="submit">Continue</button>
          </div>
        </div>
      </form>
      <script>
      // Auto-fill ISIC Code/Description based on Industry selection
      (function(){
        const select = document.getElementById('isicIndustry');
        if(!select) return;
        const codeEl = document.querySelector('input[name="isic_code"]');
        const descEl = document.querySelector('input[name="isic_desc"]');
        const map = {
          'Technology': { code: 'J62', desc: 'Computer programming, consultancy and related activities' },
          'Banking': { code: 'K64', desc: 'Financial service activities, except insurance and pension funding' },
          'Insurance': { code: 'K65', desc: 'Insurance, reinsurance and pension funding' },
          'Manufacturing': { code: 'C', desc: 'Manufacturing' },
          'Agriculture': { code: 'A01', desc: 'Crop and animal production, hunting and related service activities' },
          'Construction': { code: 'F', desc: 'Construction' },
          'Education': { code: 'P85', desc: 'Education' },
          'Healthcare': { code: 'Q86', desc: 'Human health activities' },
          'Transportation': { code: 'H49', desc: 'Land transport and transport via pipelines' },
          'Real Estate': { code: 'L68', desc: 'Real estate activities' },
          'Energy': { code: 'D35', desc: 'Electricity, gas, steam and air conditioning supply' },
          'Hospitality': { code: 'I55', desc: 'Accommodation' },
          'Retail': { code: 'G47', desc: 'Retail trade, except of motor vehicles and motorcycles' },
          'Mining': { code: 'B', desc: 'Mining and quarrying' },
          'Telecommunications': { code: 'J61', desc: 'Telecommunications' }
        };
        function apply(){
          const v = select.value;
          if(map[v]){
            if(codeEl) codeEl.value = map[v].code;
            if(descEl) descEl.value = map[v].desc;
          }
        }
        select.addEventListener('change', apply);
      })();
      </script>
      <?php endif; ?>

      <?php if($step===4): ?>
      <form method="post" id="peopleForm">
        <div class="card shadow-sm">
          <div class="card-body">
            <?php if($step_error): ?><div class="alert alert-danger"><?php echo e($step_error) ?></div><?php endif; ?>
            <div class="row">
              <div class="col-12 col-lg-6">
                <h6>Directors</h6>
                <div id="directorsList"></div>
                <button class="btn btn-sm btn-outline-primary mt-2" type="button" onclick="addDirector()">Add Director</button>
              </div>
              <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <h6>Shareholders / Guarantors</h6>
                <div id="ownersList"></div>
                <button class="btn btn-sm btn-outline-primary mt-2" type="button" onclick="addOwner()">Add Person</button>
              </div>
            </div>
          </div>
          <div class="card-footer d-flex justify-content-between">
            <a class="btn btn-outline-secondary" href="apply.php?step=3">Back</a>
            <button class="btn btn-primary" type="submit">Continue</button>
          </div>
        </div>
      </form>
      <script>
      const directorsSeed = <?php echo json_encode($_SESSION['apply']['directors'] ?? []);?>;
      const ownersSeed = <?php echo json_encode($_SESSION['apply']['owners'] ?? []);?>;
      function rowHtml(prefix, idx, values){
        const v = Object.assign({name:'',id:'',email:'',phone:'',percent:'',nat:'',dob:'',pob:'',positions:''}, values||{});
        let ownerExtra = `<div class="col-12 col-md-6 col-lg-4"><input name="owners_percent[]" class="form-control" placeholder="% Ownership" value="${v.percent||''}"></div>`;
        let header = prefix==='directors' ? 'Director' : 'Shareholder';
        return `<div class="border rounded p-2 mb-2">
          <div class="small text-muted mb-1">${header} details</div>
          <div class="row g-2 align-items-center">
            <div class="col-12 col-md-6 col-lg-4"><input name="${prefix}_name[]" class="form-control" placeholder="Full name" value="${v.name||''}"></div>
            <div class="col-12 col-md-6 col-lg-4"><input name="${prefix}_id[]" class="form-control" placeholder="ID / TIN" value="${v.id||''}"></div>
            ${prefix==='directors' ? `<div class="col-12 col-md-6 col-lg-4"><input name="directors_phone[]" class="form-control" placeholder="Phone" value="${v.phone||''}"></div>` : ownerExtra}
          </div>
          <div class="row g-2 mt-1">
            <div class="col-12 col-md-4 col-lg-3"><input type="date" name="${prefix}_dob[]" class="form-control" placeholder="Date of birth" value="${v.dob||''}"></div>
            <div class="col-12 col-md-4 col-lg-3"><input name="${prefix}_pob[]" class="form-control" placeholder="Place of birth" value="${v.pob||''}"></div>
            <div class="col-12 col-md-4 col-lg-3"><input name="${prefix}_nat[]" class="form-control" placeholder="Nationality" value="${v.nat||''}"></div>
            ${prefix==='directors' ? `<div class="col-12 col-md-6 col-lg-3"><input name="directors_positions[]" class="form-control" placeholder="Directorship positions (prev/current)" value="${v.positions||''}"></div>` : ''}
          </div>
          ${prefix==='directors' ? `<div class="row g-2 mt-1"><div class="col-12 col-md-6"><input name="directors_email[]" class="form-control" placeholder="Email" value="${v.email||''}"></div></div>` : ''}
        </div>`;
      }
      function renderList(id, prefix, seed){
        const el = document.getElementById(id);
        el.innerHTML = '';
        if(seed && seed.length){ seed.forEach((v,i)=>{ el.insertAdjacentHTML('beforeend', rowHtml(prefix,i,v)); }); }
        else { el.insertAdjacentHTML('beforeend', rowHtml(prefix,0,{})); }
      }
      function addDirector(){ document.getElementById('directorsList').insertAdjacentHTML('beforeend', rowHtml('directors',Date.now(),{})); }
      function addOwner(){ document.getElementById('ownersList').insertAdjacentHTML('beforeend', rowHtml('owners',Date.now(),{})); }
      renderList('directorsList','directors',directorsSeed);
      renderList('ownersList','owners',ownersSeed);
      // Client-side validation: require at least 2 directors and 2 shareholders
      (function(){
        const form = document.getElementById('peopleForm');
        if(!form) return;
        form.addEventListener('submit', function(e){
          function countFilled(prefix){
            const names = Array.from(document.querySelectorAll(`input[name="${prefix}_name[]"]`));
            return names.filter(n => (n.value||'').trim() !== '').length;
          }
          const dCount = countFilled('directors');
          const oCount = countFilled('owners');
          if(dCount < 2 || oCount < 2){
            e.preventDefault();
            alert('Please provide at least two Directors and at least two Shareholders/Guarantors.');
          }
        });
      })();
      </script>
      <?php endif; ?>

      <?php if($step===5): $t = $_SESSION['apply']['company_type'] ?? ''; $req = required_docs_for_type($t); ?>
      <form method="post" enctype="multipart/form-data" id="submitForm">
        <div class="card shadow-sm">
          <div class="card-body">
             <?php if($pay_error): ?><div class="alert alert-danger"><?php echo e($pay_error) ?></div><?php endif; ?>
             <div class="alert alert-info">Total fee: <strong>GHS <?php echo e(money(fee_for_type($_SESSION['apply']['company_type'] ?? ''))) ?></strong>. You will be prompted to pay via Paystack before submission.</div>
             <div class="alert alert-info">Provide details for the required documents below. Capture your Ghana Card using your camera, or choose a file from your device.</div>
            <?php $file_docs = ['ID_DOC','SEC_QUAL','AUD_QUAL','DIR_STAT_DECL','DIR_CONSENT','AUD_CONSENT_DECL','CONSTITUTION','BO_FORM','FORM_OF_INCORP','DIRECTORS_IDS']; ?>
            <?php foreach($req as $dk): $lbl = doc_labels()[$dk] ?? $dk; ?>
              <div class="mb-3">
                <label class="form-label"><?php echo e($lbl) ?></label>
                <?php if (in_array($dk, $file_docs)): ?>
                  <?php if ($dk==='ID_DOC'): ?>
                    <input type="file" id="idDocFile" name="doc_<?php echo e($dk)?>" class="form-control" accept="image/*" capture="environment">
                    <div class="form-text">Use your device camera to capture your Ghana Card, or choose a file.</div>
                    <div class="mt-2"><button class="btn btn-outline-secondary btn-sm" type="button" id="openCameraBtn">Use Camera</button></div>
                    <div id="cameraArea" class="mt-2" style="display:none">
                      <video id="cameraVideo" autoplay playsinline style="width:100%;max-height:300px;background:#000;border-radius:.25rem"></video>
                      <canvas id="cameraCanvas" style="display:none"></canvas>
                      <div class="mt-2 d-flex gap-2">
                        <button class="btn btn-primary btn-sm" type="button" id="captureBtn">Capture</button>
                        <button class="btn btn-success btn-sm" type="button" id="usePhotoBtn" disabled>Use Photo</button>
                        <button class="btn btn-outline-secondary btn-sm" type="button" id="retakeBtn" disabled>Retake</button>
                        <button class="btn btn-outline-danger btn-sm" type="button" id="closeCameraBtn">Close</button>
                      </div>
                      <img id="photoPreview" alt="Preview" style="display:none;margin-top:.5rem;max-width:100%;border:1px solid #ddd;border-radius:.25rem" />
                    </div>
                  <?php elseif (in_array($dk, ['DIR_STAT_DECL','DIR_CONSENT','DIRECTORS_IDS'])): ?>
                    <?php $required_pl = (($_SESSION['apply']['company_type'] ?? '')==='PRIVATE_LIMITED') && in_array($dk,['DIRECTORS_IDS','DIR_CONSENT']); ?>
                    <input type="file" name="doc_<?php echo e($dk)?>[]" class="form-control mb-1" <?php echo $required_pl?'required':''; ?>>
                    <input type="file" name="doc_<?php echo e($dk)?>[]" class="form-control mb-1">
                    <input type="file" name="doc_<?php echo e($dk)?>[]" class="form-control">
                    <div class="form-text">Upload up to 3 files (one per director).</div>
                  <?php else: ?>
                    <?php $required_pl = (($_SESSION['apply']['company_type'] ?? '')==='PRIVATE_LIMITED') && in_array($dk,['BO_FORM','CONSTITUTION','FORM_OF_INCORP','AUD_CONSENT_DECL']); ?>
                    <input type="file" name="doc_<?php echo e($dk)?>" class="form-control" <?php echo $required_pl?'required':''; ?>>
                  <?php endif; ?>
                <?php else: ?>
                  <textarea name="doctext_<?php echo e($dk)?>" class="form-control" rows="2" placeholder="Provide details here"></textarea>
                <?php endif; ?>
              </div>
            <?php endforeach; ?>
            <input type="hidden" name="paystack_ref" id="paystack_ref" value="">
          </div>
          <div class="card-footer d-flex justify-content-between">
            <a class="btn btn-outline-secondary" href="apply.php?step=4">Back</a>
            <button class="btn btn-success" type="button" id="payAndSubmit">Pay & Submit Application</button>
          </div>
        </div>
      </form>
      <script>
      (function(){
        const openBtn = document.getElementById('openCameraBtn');
        if(!openBtn) return;
        const closeBtn = document.getElementById('closeCameraBtn');
        const captureBtn = document.getElementById('captureBtn');
        const usePhotoBtn = document.getElementById('usePhotoBtn');
        const retakeBtn = document.getElementById('retakeBtn');
        const area = document.getElementById('cameraArea');
        const video = document.getElementById('cameraVideo');
        const canvas = document.getElementById('cameraCanvas');
        const preview = document.getElementById('photoPreview');
        const fileInput = document.getElementById('idDocFile');
        let stream = null;
        let capturedBlob = null;

        async function startCamera(){
          try{
            stream = await navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'}});
            video.srcObject = stream;
            area.style.display = '';
            preview.style.display = 'none';
            usePhotoBtn.disabled = true;
            retakeBtn.disabled = true;
          }catch(e){
            alert('Unable to access camera on this device. You can choose a file instead.');
          }
        }
        function stopCamera(){
          if(stream){ stream.getTracks().forEach(t=>t.stop()); stream = null; }
          area.style.display = 'none';
        }
        function capture(){
          const w = video.videoWidth || 1280;
          const h = video.videoHeight || 720;
          canvas.width = w; canvas.height = h;
          const ctx = canvas.getContext('2d');
          ctx.drawImage(video,0,0,w,h);
          canvas.toBlob(function(blob){
            capturedBlob = blob;
            const url = URL.createObjectURL(blob);
            preview.src = url;
            preview.style.display = '';
            usePhotoBtn.disabled = false;
            retakeBtn.disabled = false;
          }, 'image/jpeg', 0.92);
        }
        function usePhoto(){
          if(!capturedBlob) return;
          const file = new File([capturedBlob], 'ghana-card.jpg', {type:'image/jpeg'});
          const dt = new DataTransfer();
          dt.items.add(file);
          fileInput.files = dt.files;
          stopCamera();
        }
        function retake(){
          preview.style.display = 'none';
          usePhotoBtn.disabled = true;
          retakeBtn.disabled = true;
          capturedBlob = null;
        }

        openBtn.addEventListener('click', startCamera);
        if(captureBtn) captureBtn.addEventListener('click', capture);
        if(usePhotoBtn) usePhotoBtn.addEventListener('click', usePhoto);
        if(retakeBtn) retakeBtn.addEventListener('click', retake);
        if(closeBtn) closeBtn.addEventListener('click', stopCamera);
        const form = document.getElementById('submitForm');
        if(form) form.addEventListener('submit', stopCamera);
        window.addEventListener('beforeunload', stopCamera);
      })();
      </script>
      <div id="payOverlay" style="display:none; position:fixed; inset:0; background:rgba(0,0,0,.35); z-index:1055; align-items:center; justify-content:center;">
        <div class="text-white bg-dark rounded px-3 py-2 shadow">Opening payment...</div>
      </div>
      <script src="https://js.paystack.co/v1/inline.js"></script>
      <script>
      (function(){
        const btn = document.getElementById('payAndSubmit');
        if(!btn) return;
        const form = document.getElementById('submitForm');
        const refInput = document.getElementById('paystack_ref');
        const overlay = document.getElementById('payOverlay');
        const pk = <?php echo json_encode((string)(paystack_cfg()['public_key'] ?? '')); ?>;
        const email = <?php echo json_encode((string)($_SESSION['apply']['applicant_email'] ?? 'applicant@example.com')); ?>;
        const amountKobo = <?php echo (int)round(fee_for_type($_SESSION['apply']['company_type'] ?? '')*100); ?>; // Paystack expects minor units: GHS in pesewas

        function showOverlay(){ if(overlay){ overlay.style.display = 'flex'; } }
        function hideOverlay(){ if(overlay){ overlay.style.display = 'none'; } }
        function simulate(msg){ hideOverlay(); if(msg) alert(msg+' Proceeding with simulated payment.'); refInput.value = 'SIM-'+Date.now(); form.submit(); }

        btn.addEventListener('click', function(){
          // Pre-validate required uploads for Private Limited
          const type = <?php echo json_encode((string)($_SESSION['apply']['company_type'] ?? '')); ?>;
          if(type==='PRIVATE_LIMITED'){
            const bo = document.querySelector('input[name="doc_BO_FORM"]');
            const cons = document.querySelector('input[name="doc_CONSTITUTION"]');
            const inc = document.querySelector('input[name="doc_FORM_OF_INCORP"]');
            const aud = document.querySelector('input[name="doc_AUD_CONSENT_DECL"]');
            const dirInputs = document.querySelectorAll('input[name="doc_DIRECTORS_IDS[]"]');
            const dirConsInputs = document.querySelectorAll('input[name="doc_DIR_CONSENT[]"]');
            let dirHas=false; dirInputs.forEach(i=>{ if(i && i.files && i.files.length>0) dirHas=true; });
            let dirConsHas=false; dirConsInputs.forEach(i=>{ if(i && i.files && i.files.length>0) dirConsHas=true; });
            if(!bo || !bo.files || bo.files.length===0 || !cons || !cons.files || cons.files.length===0 || !inc || !inc.files || inc.files.length===0 || !dirHas || !aud || !aud.files || aud.files.length===0 || !dirConsHas){
              alert('Please upload Company Constitution/Regulations, Incorporation Form, Beneficial Ownership Form, Directors IDs, Auditor Consent Declaration, and Director Consent before proceeding to payment.');
              return;
            }
          }
          if(!pk){ simulate('Payment keys not configured.'); return; }
          btn.disabled = true; showOverlay();

          function openPaystack(){
            try{
              const handler = PaystackPop.setup({
                key: pk,
                email: email||'applicant@example.com',
                amount: amountKobo,
                currency: 'GHS',
                ref: 'RGD'+Date.now(),
                callback: function(response){ hideOverlay(); refInput.value = response.reference; form.submit(); },
                onClose: function(){ hideOverlay(); btn.disabled = false; }
              });
              handler.openIframe();
            }catch(e){ simulate('Unable to open payment window.'); btn.disabled = false; }
          }
          openPaystack();
        });
      })();
      </script>
      <?php endif; ?>
      <div class="text-center mt-4"><a href="index.php" class="link-secondary">Cancel</a></div>
    </div>
  </div>
</div>
</body></html>
