<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/util.php';
require_once __DIR__ . '/notify.php';
function add_status($app_id,$status,$note,$user_id=null){
  db_execute('INSERT INTO status_history(app_id,status,note,user_id,created_at) VALUES(?,?,?,?,?)',[$app_id,$status,$note,$user_id,now()]);
}
function set_status($app_id,$status,$note,$user_id=null){
  db_execute('UPDATE applications SET status=? WHERE id=?',[$status,$app_id]);
  add_status($app_id,$status,$note,$user_id);
}
function add_message($app_id,$direction,$subject,$body,$user_id=null){
  db_execute('INSERT INTO messages(app_id,direction,subject,body,user_id,created_at) VALUES(?,?,?,?,?,?)',[$app_id,$direction,$subject,$body,$user_id,now()]);
  if ($direction === 'OUT') { notify_applicant_message($app_id, $subject, $body); }
}
function find_app_by_tracking($tracking){
  return db_fetch('SELECT * FROM applications WHERE tracking_no=?',[$tracking]);
}
?>
