<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/util.php';

function notify_log($channel,$payload){
  $dir = __DIR__ . '/../data'; if(!is_dir($dir)) @mkdir($dir,0777,true);
  $line = '['.now()."] $channel " . json_encode($payload, JSON_UNESCAPED_UNICODE) . "\n";
  @file_put_contents($dir.'/notify.log',$line,FILE_APPEND);
}

function notify_sms($to, $message){
  $cfg = mnotify_cfg();
  $key = trim((string)$cfg['api_key']);
  $sender = substr(trim((string)$cfg['sender_id']),0,11) ?: 'RGD';
  if($key==='') { notify_log('sms',['to'=>$to,'message'=>$message,'note'=>'mNotify api_key not set. Logged only.']); return ['ok'=>false,'logged'=>true]; }
  $url = 'https://api.mnotify.com/api/sms/quick?key='.rawurlencode($key);
  $payload = [
    'recipient' => [ (string)$to ],
    'sender' => $sender,
    'message' => (string)$message
  ];
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_POST, 1);
  curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload, JSON_UNESCAPED_UNICODE));
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  $resp = curl_exec($ch);
  $err = curl_error($ch);
  curl_close($ch);
  notify_log('sms',['to'=>$to,'payload'=>$payload,'resp'=>$resp,'err'=>$err]);
  if($err) return ['ok'=>false,'error'=>$err];
  $data = json_decode($resp,true);
  return ['ok'=>true,'data'=>$data];
}

function notify_email($to,$subject,$body){
  $cfg = email_cfg();
  $mode = $cfg['mode'];
  if($mode==='log' || $mode===''){
    notify_log('email',['to'=>$to,'subject'=>$subject,'body'=>$body]);
    return ['ok'=>true,'logged'=>true];
  }
  if($mode==='mail'){
    $headers = 'From: '.($cfg['from_name'].' <'.$cfg['from_addr'].'>');
    @mail($to,$subject,$body,$headers);
    notify_log('email',['to'=>$to,'subject'=>$subject,'body'=>$body,'mode'=>'mail']);
    return ['ok'=>true,'mode'=>'mail'];
  }
  // Placeholder for SMTP implementation in prototype
  notify_log('email',['to'=>$to,'subject'=>$subject,'body'=>$body,'mode'=>'smtp','note'=>'SMTP not configured in prototype']);
  return ['ok'=>false,'error'=>'smtp not configured'];
}

function notify_applicant_message($app_id,$subject,$body){
  $app = db_fetch('SELECT applicant_email, phone FROM applications WHERE id=?',[$app_id]);
  if(!$app) return;
  if(!empty($app['phone'])) notify_sms($app['phone'], $subject.': '.$body);
  if(!empty($app['applicant_email'])) notify_email($app['applicant_email'], $subject, $body);
}
?>
