<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
$u = auth_user(); if(!$u){ header('Location: login.php'); exit; }
$brand = brand();
$stage = $_GET['stage'] ?? 'intake';
$map = [
  'intake'=>['role'=>'INTAKE','title'=>'Intake Queue','statuses'=>['SUBMITTED','INTAKE_REVIEW','RFI']],
  'registrar'=>['role'=>'REGISTRAR','title'=>'Registrar Queue','statuses'=>['FOR_REGISTRAR','REGISTRAR_REVIEW','RFI']],
  'authorizer'=>['role'=>'AUTHORIZER','title'=>'Authorization Queue','statuses'=>['FOR_AUTHORIZATION','RFI']],
  'finance'=>['role'=>'FINANCE','title'=>'Finance Queue','statuses'=>['AUTHORIZED','PAYMENT_CONFIRMED']],
];
if (!isset($map[$stage])){ http_response_code(404); echo 'Invalid stage'; exit; }
$def = $map[$stage];
if ($u['role']!=='ADMIN' && $u['role']!==$def['role']){ http_response_code(403); echo 'Not allowed for your role'; exit; }
$statuses = $def['statuses'];
$in = implode("','", array_map('strval',$statuses));
$search = trim($_GET['q'] ?? '');
$sql = "SELECT * FROM applications WHERE status IN ('{$in}')";
$params = [];
if ($search !== ''){
  $sql .= " AND (tracking_no LIKE ? OR company_name LIKE ?)";
  $params[] = "%{$search}%"; $params[] = "%{$search}%";
}
$sql .= " ORDER BY id DESC";
$rows = db_fetch_all($sql, $params);
?>
<?php $page_title=$def['title']; $active_menu=$stage; include __DIR__.'/partials/layout_start.php'; ?>
<div>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0"><?php echo e($def['title']) ?></h3>
    <a class="btn btn-outline-secondary" href="index.php">Back</a>
  </div>
  <form class="mb-3" method="get">
    <input type="hidden" name="stage" value="<?php echo e($stage) ?>">
    <div class="input-group">
      <input name="q" value="<?php echo e($search) ?>" class="form-control" placeholder="Search by tracking or company name">
      <button class="btn btn-outline-secondary">Search</button>
    </div>
  </form>
  <div class="table-responsive">
    <table class="table table-striped align-middle">
      <thead><tr><th>Tracking</th><th>Company</th><th>Type</th><th>Status</th><th>Created</th><th></th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
        <tr>
          <td><code><?php echo e($r['tracking_no']) ?></code></td>
          <td><?php echo e($r['company_name']) ?></td>
          <td><?php echo e(company_types()[$r['company_type']] ?? $r['company_type']) ?></td>
          <td><?php echo e(statuses()[$r['status']] ?? $r['status']) ?></td>
          <td class="text-muted small"><?php echo e($r['created_at']) ?></td>
          <td><a class="btn btn-sm btn-primary" href="app.php?id=<?php echo (int)$r['id'] ?>">Open</a></td>
        </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="6" class="text-center text-muted">No items in queue.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/partials/layout_end.php'; ?>
