<?php
require_once __DIR__ . '/../../lib/util.php';
require_once __DIR__ . '/../../lib/config.php';
$brand = $brand ?? brand();
$page_title = $page_title ?? 'Back Office';
$active_menu = $active_menu ?? '';
$u = $u ?? null;
?>
<!doctype html>
<html lang="en" class="layout-menu-fixed layout-compact" data-assets-path="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/" data-template="vertical-menu-template-free">
<head>
  <meta charset="utf-8">
  <title><?php echo e($page_title) ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/vendor/fonts/tabler-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/vendor/fonts/iconify-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/vendor/libs/node-waves/node-waves.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/vendor/css/core.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/vendor/css/theme-default.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/css/demo.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css">
  <style>:root{--brand: <?php echo e($brand['color']) ?>}</style>
  <script src="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/vendor/js/helpers.js"></script>
  <script src="https://cdn.jsdelivr.net/gh/themeselection/materio-bootstrap-html-admin-template-free@main/assets/js/config.js"></script>
</head>
<body>
  <div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
      <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
        <div class="app-brand demo p-3">
          <a href="index.php" class="app-brand-link d-flex align-items-center text-decoration-none">
            <?php if($brand['logo']): ?><img src="<?php echo e(brand_logo_src()) ?>" alt="Logo" style="height:28px" class="me-2"><?php endif; ?>
            <span class="app-brand-text demo fw-bold"><?php echo e($brand['name']) ?></span>
          </a>
        </div>
        <ul class="menu-inner py-1">
          <li class="menu-item<?php echo $active_menu==='dashboard'?' active':''; ?>"><a href="index.php" class="menu-link"><div>Dashboard</div></a></li>
          <?php if(!$u || $u['role']==='ADMIN' || $u['role']==='INTAKE'): ?>
            <li class="menu-item<?php echo $active_menu==='intake'?' active':''; ?>"><a class="menu-link" href="queue.php?stage=intake"><div>Intake Queue</div></a></li>
          <?php endif; ?>
          <?php if(!$u || $u['role']==='ADMIN' || $u['role']==='REGISTRAR'): ?>
            <li class="menu-item<?php echo $active_menu==='registrar'?' active':''; ?>"><a class="menu-link" href="queue.php?stage=registrar"><div>Registrar Queue</div></a></li>
          <?php endif; ?>
          <?php if(!$u || $u['role']==='ADMIN' || $u['role']==='AUTHORIZER'): ?>
            <li class="menu-item<?php echo $active_menu==='authorizer'?' active':''; ?>"><a class="menu-link" href="queue.php?stage=authorizer"><div>Authorization Queue</div></a></li>
          <?php endif; ?>
          <?php if(!$u || $u['role']==='ADMIN' || $u['role']==='FINANCE'): ?>
            <li class="menu-item<?php echo $active_menu==='finance'?' active':''; ?>"><a class="menu-link" href="queue.php?stage=finance"><div>Finance Queue</div></a></li>
          <?php endif; ?>
          <?php if($u && $u['role']==='ADMIN'): ?>
            <li class="menu-item<?php echo $active_menu==='settings'?' active':''; ?>"><a class="menu-link" href="settings.php"><div>Settings</div></a></li>
          <?php endif; ?>
          <li class="menu-item"><a class="menu-link" href="logout.php"><div>Logout</div></a></li>
        </ul>
      </aside>
      <div class="layout-page">
        <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
          <div class="container-fluid">
            <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
              <a class="nav-link px-0 me-xl-4 layout-menu-toggle" href="javascript:void(0)">
                <i class="ti ti-menu-2 ti-sm"></i>
              </a>
            </div>
            <span class="navbar-brand mb-0 h5"><?php echo e($page_title) ?></span>
            <?php if($u): ?><span class="ms-auto small text-muted">Signed in as <?php echo e($u['name']) ?> (<?php echo e($u['role']) ?>)</span><?php endif; ?>
          </div>
        </nav>
        <div class="content-wrapper">
          <div class="container-xxl flex-grow-1 container-p-y">
