<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/config.php';
$u = auth_user(); if(!$u){ header('Location: login.php'); exit; }
$brand = brand();
function count_status($arr){ if(!$arr) return 0; $in = implode("','", array_map('strval',$arr)); $row = db_fetch("SELECT COUNT(*) c FROM applications WHERE status IN ('".$in."')", []); return (int)($row['c']??0); }
$cards = [
  'INTAKE'=>['title'=>'Intake Queue','stage'=>'intake','statuses'=>['SUBMITTED','INTAKE_REVIEW'],'color'=>'primary'],
  'REGISTRAR'=>['title'=>'Registrar Queue','stage'=>'registrar','statuses'=>['FOR_REGISTRAR','REGISTRAR_REVIEW'],'color'=>'warning'],
  'AUTHORIZER'=>['title'=>'Authorization Queue','stage'=>'authorizer','statuses'=>['FOR_AUTHORIZATION'],'color'=>'info'],
  'FINANCE'=>['title'=>'Finance Queue','stage'=>'finance','statuses'=>['AUTHORIZED','PAYMENT_CONFIRMED'],'color'=>'success'],
];
$page_title='Dashboard';
$active_menu='dashboard';
include __DIR__.'/partials/layout_start.php';
?>
<div>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Dashboard</h3>
    <a class="btn btn-outline-secondary" href="../index.php">Prototype Home</a>
  </div>
  <div class="row g-4">
    <?php foreach($cards as $role=>$c): if($u['role']!=='ADMIN' && $u['role']!==$role) continue; $cnt = count_status($c['statuses']); ?>
      <div class="col-md-6 col-lg-3">
        <div class="card border-<?php echo e($c['color']) ?>">
          <div class="card-body">
            <div class="text-muted small">Queue</div>
            <div class="h5"><?php echo e($c['title']) ?></div>
            <div class="display-6"><?php echo e($cnt) ?></div>
            <a class="btn btn-sm btn-<?php echo e($c['color']) ?> mt-2" href="queue.php?stage=<?php echo urlencode($c['stage']) ?>">Open Queue</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
  <div class="mt-4">
    <div class="card shadow-sm"><div class="card-body">
      <div class="h5 mb-3">Recent Applications</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Tracking</th><th>Company</th><th>Type</th><th>Status</th><th>Created</th><th></th></tr></thead>
          <tbody>
          <?php foreach(db_fetch_all('SELECT * FROM applications ORDER BY id DESC LIMIT 10') as $a): ?>
            <tr>
              <td><code><?php echo e($a['tracking_no']) ?></code></td>
              <td><?php echo e($a['company_name']) ?></td>
              <td><?php echo e(company_types()[$a['company_type']] ?? $a['company_type']) ?></td>
              <td><?php echo e(statuses()[$a['status']] ?? $a['status']) ?></td>
              <td class="text-muted small"><?php echo e($a['created_at']) ?></td>
              <td><a class="btn btn-sm btn-outline-primary" href="app.php?id=<?php echo (int)$a['id'] ?>">Open</a></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div></div>
  </div>
</div>
<?php include __DIR__.'/partials/layout_end.php'; ?>
